/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils.item;

import com.cleanroommc.modularui.utils.item.IItemHandlerModifiable;
import com.google.common.base.Preconditions;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class RangedWrapper
implements IItemHandlerModifiable {
    private final IItemHandlerModifiable compose;
    private final int minSlot;
    private final int maxSlot;

    public RangedWrapper(IItemHandlerModifiable compose, int minSlot, int maxSlotExclusive) {
        Preconditions.checkArgument((maxSlotExclusive > minSlot ? 1 : 0) != 0, (Object)"Max slot must be greater than min slot");
        this.compose = compose;
        this.minSlot = minSlot;
        this.maxSlot = maxSlotExclusive;
    }

    @Override
    public int getSlots() {
        return this.maxSlot - this.minSlot;
    }

    @Override
    public ItemStack getStackInSlot(int slot) {
        if (this.checkSlot(slot)) {
            return this.compose.getStackInSlot(slot + this.minSlot);
        }
        return null;
    }

    @Override
    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (this.checkSlot(slot)) {
            return this.compose.insertItem(slot + this.minSlot, stack, simulate);
        }
        return stack;
    }

    @Override
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.checkSlot(slot)) {
            return this.compose.extractItem(slot + this.minSlot, amount, simulate);
        }
        return null;
    }

    @Override
    public void setStackInSlot(int slot, ItemStack stack) {
        if (this.checkSlot(slot)) {
            this.compose.setStackInSlot(slot + this.minSlot, stack);
        }
    }

    @Override
    public int getSlotLimit(int slot) {
        if (this.checkSlot(slot)) {
            return this.compose.getSlotLimit(slot + this.minSlot);
        }
        return 0;
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        if (this.checkSlot(slot)) {
            return this.compose.isItemValid(slot + this.minSlot, stack);
        }
        return false;
    }

    private boolean checkSlot(int localSlot) {
        return localSlot + this.minSlot < this.maxSlot;
    }

    public IItemHandlerModifiable getCompose() {
        return this.compose;
    }

    @Override
    public boolean isSlotFromInventory(int index, IInventory inventory, int invIndex) {
        return this.compose.isSlotFromInventory(index + this.minSlot, inventory, invIndex);
    }
}

